uniform vec4 Ambient;
uniform vec4 Specular;
uniform vec4 Diffuse;
uniform float SpecularPower;
uniform sampler2D texture;
varying vec2 Texcoord;
varying vec3 ViewDirection;
varying vec3 LightDirection;
varying vec3 Normal;

void main( void )
{
   vec3  vLightDirection = normalize( LightDirection );
   vec3  vNormal         = normalize( Normal );
   float NDotL           = dot( vNormal, vLightDirection ); 
   vec3  vReflection     = normalize( ( ( 2.0 * vNormal ) * NDotL ) - vLightDirection ); 
   vec3  vViewDirection  = normalize( ViewDirection );
   float RDotV           = max( 0.0, dot( vReflection, vViewDirection ) );
   vec4  BaseColor      = texture2D( texture, Texcoord );
   vec4  TAmbient   = Ambient * BaseColor; 
   vec4  TDiffuse   = Diffuse * NDotL * BaseColor; 
   vec4  TSpecular  = Specular * ( pow( RDotV, SpecularPower ) );
   gl_FragColor = ( TAmbient + TDiffuse + TSpecular );
}